-- moonlight Theme Preferences Handler

--[[ theme colors ]]
-- limited choices version:
ThemeColors = {
	  Yellow = "#FFFFFB",	-- a: yellow (default/classic)
	  Purple = "#FFFBFF",	-- b: purple
		Cyan = "#FBFFFF",	-- c: cyan
		 Red = "#FFFBFB",	-- d: red
	   Green = "#FBFFFB",	-- e: green
		Blue = "#FBFBFF",	-- f: blue
	 Special = "#EBFAFF",	-- special color!
	--Midnight = "#176073",	-- special color 2 (might have to swap text colors)
};

function GetThemeColor()
	if GetUserPref("ThemeColor") then
		return GetUserPrefC("ThemeColor");
	else
		SetUserPref("ThemeColor",ThemeColors['Yellow']);
		return color(ThemeColors['Yellow']);
	end;
end;
--[[ end theme colors ]]

--[[ preference helpers ]]
-- this table is only used by InitPrefs [BGAnimations/ScreenTitleMenu overlay/default.lua]
local prefNamesAndDefaults = {
	-- strings
	{ "Toasty", "forden" },
	{ "SSMusicInfo", "PaneDisplay" },
	{ "JudgmentSet", "Normal" },
	{ "ComboStyle", "normal" },
	-- hex colors
	{ "ThemeColor", "#FFFFFB" },
	{ "FilterColorP1", "#00000080" },
	{ "FilterColorP2", "#00000080" },
	-- numbers
	{ "CoverPositionP1", 0 },
	{ "CoverPositionP2", 0 },
	-- bools
	{ "DisplayModsOption", true },
	{ "GameplayTitle", true },
	{ "DPMeter", true },
	{ "SongBPMDisplay", true },
	{ "TiltJudgments", true },
	{ "SmallCombo", false },
	{ "AutoSetStyle", false },
	{ "ITGArrowPosition", false },
	--{ "FunAllowed", true }, -- toggles song renaming and such.
};
function InitUserPrefs()
	-- initialize them if they don't exist
	for i=1,#prefNamesAndDefaults do
		if GetUserPref( prefNamesAndDefaults[i][1] ) == nil then
			Trace( string.format("User preference %s didn't exist, creating", prefNamesAndDefaults[i][1]) );
			SetUserPref( prefNamesAndDefaults[i][1], prefNamesAndDefaults[i][2] );
		end;
	end;
end;

function SSMusicInfoDefaultChoice() return GetUserPref("SSMusicInfo") end;
--[[ end preference helpers ]]

--[[ option rows ]]
function OptionRowSongTitleDisplay()
	local t = {
		-- Name is used to retrieve the header and explanation text.
		Name = "Song/Course Title Display";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = false;
		Choices = { 'On','Off' };
		LoadSelections = function(self, list, pn)
			if GetUserPrefB("GameplayTitle") then
				list[1] = true;
			else
				list[2] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[2] then
				val = false;
			else
				val = true;
			end
			SetUserPref("GameplayTitle",val);
		end;
	};
	setmetatable( t, t );
	return t;
end;

function OptionRowPlayerOptionsDisplay()
	local t = {
		Name = "Player Options Display";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = false;
		Choices = { 'On','Off' };
		LoadSelections = function(self, list, pn)
			if GetUserPrefB("DisplayModsOption") then
				list[1] = true;
			else
				list[2] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[2] then
				val = false;
			else
				val = true;
			end
			SetUserPref("DisplayModsOption",val);
		end;
	};
	setmetatable( t, t );
	return t;
end;

-- screen filter
function OptionRowPlayerFilter()
	local t = {
		Name = "Screen Filter";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = false;
		ExportOnChange = false;
		Choices = { 'Off','On' };
		LoadSelections = function(self, list, pn)
			local pname = pname(pn);

			if getenv("ScreenFilter"..pname) == true then
				list[2] = true;
			else
				list[1] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[2] then
				val = true;
			else
				val = false;
			end;
			local pname = pname(pn);
			setenv("ScreenFilter"..pname, val);
		end;
	};
	setmetatable( t, t );
	return t;
end;

-- screen cover
function OptionRowPlayerCover()
	local t = {
		Name = "Screen Cover";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = false;
		ExportOnChange = false;
		Choices = { 'Off','On' };
		LoadSelections = function(self, list, pn)
			local pname = pname(pn);

			if getenv("ScreenCover"..pname) == true then
				list[2] = true;
			else
				list[1] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[2] then
				val = true;
			else
				val = false;
			end;
			local pname = pname(pn);
			setenv("ScreenCover"..pname, val);
		end;
	};
	setmetatable( t, t );
	return t;
end;

function OptionRowDPMeterDisplay()
	local t = {
		Name = "Dance Point Meter Display";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = false;
		Choices = { 'On','Off' };
		LoadSelections = function(self, list, pn)
			if GetUserPref("DPMeter") == "false" then
				list[2] = true;
			else
				list[1] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[2] then
				val = false;
			else
				val = true;
			end
			SetUserPref("DPMeter",val);
		end;
	};
	setmetatable( t, t );
	return t;
end;

function OptionRowBPMDisplay()
	local t = {
		Name = "BPM Display";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = false;
		Choices = { 'On','Off' };
		LoadSelections = function(self, list, pn)
			if GetUserPref("SongBPMDisplay") == "false" then
				list[2] = true;
			else
				list[1] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[2] then
				val = false;
			else
				val = true;
			end
			SetUserPref("SongBPMDisplay",val);
		end;
	};
	setmetatable( t, t );
	return t;
end;

function OptionRowJudgeDisplay()
	local t = {
		Name = "Judgment Display";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = false;
		Choices = { 'Normal','Offset' };
		LoadSelections = function(self, list, pn)
			if GetUserPref("JudgmentSet") == "Offset" then
				list[2] = true;
			else
				list[1] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[2] then
				val = "Offset";
			else
				val = "Normal";
			end
			SetUserPref("JudgmentSet",val);
		end;
	};
	setmetatable( t, t );
	return t;
end;

function OptionRowTiltJudgmentDisplay()
	local t = {
		Name = "Tilt Judgments";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = false;
		Choices = { 'On','Off' };
		LoadSelections = function(self, list, pn)
			if GetUserPref("TiltJudgments") == "false" then
				list[2] = true;
			else
				list[1] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[2] then
				val = false;
			else
				val = true;
			end
			SetUserPref("TiltJudgments",val);
		end;
	};
	setmetatable( t, t );
	return t;
end;

function OptionRowComboStyle()
	local t = {
		Name = "Combo Color";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = false;
		Choices = { 'Player','Best Combo' };
		LoadSelections = function(self, list, pn)
			if GetUserPref("ComboStyle") == "combo" then
				list[2] = true;
			else
				list[1] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[2] then
				val = "combo";
			else
				val = "normal";
			end
			SetUserPref("ComboStyle",val);
		end;
	};
	setmetatable( t, t );
	return t;
end;

function OptionRowSmallCombo()
	local t = {
		Name = "Combo Size";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = false;
		Choices = { 'Normal','Small' };
		LoadSelections = function(self, list, pn)
			if GetUserPref("SmallCombo") == "false" then
				list[1] = true;
			else
				list[2] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[1] then
				val = false;
			else
				val = true;
			end
			SetUserPref("SmallCombo",val);
		end;
	};
	setmetatable( t, t );
	return t;
end;

function OptionRowArrowPosition()
	local t = {
		Name = "Arrow Position";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = false;
		Choices = { 'Normal','ITG' };
		LoadSelections = function(self, list, pn)
			if GetUserPref("ITGArrowPosition") == "false" then
				list[1] = true;
			else
				list[2] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			if list[1] then val = false
			else val = true
			end
			SetUserPref("ITGArrowPosition",val);
		end;
	};
	setmetatable( t, t );
	return t;
end;


function OptionRowAutoSetStyle()
	local t = {
		-- Name is used to retrieve the header and explanation text.
		Name = "AutoSetStyle";
		LayoutType = "ShowAllInRow";
		SelectType = "SelectOne";
		OneChoiceForAllPlayers = true;
		ExportOnChange = false;
		Choices = { 'On','Off' };
		LoadSelections = function(self, list, pn)
			if GetUserPrefB("AutoSetStyle") then list[1] = true;
			else list[2] = true;
			end;
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[2] then val = false;
			else val = true;
			end
			SetUserPref("AutoSetStyle",val);
		end;
	};
	setmetatable( t, t );
	return t;
end;

-- GetAutoSetStyle()
function GetAutoSetStyle() return GetUserPrefB("AutoSetStyle") end;
--[[ end option rows ]]
